******************************************************************
************************* MS30675 ********************************
********* Racial Diversity and Racial Policy Preferences: ********
************* The Great Migration and Civil Rights ***************
******************************************************************
**** Alvaro Calderon *** Vasiliki Fouka *** Marco Tabellini ******
******************************************************************
******************************************************************

*** IN CASE YOU DON'T HAVE THEM, INSTALL THIS PACKAGES:
//ssc install binscatter
//ssc install distinct
//ssc install ivreg2
//ssc install xtivreg2
//ssc install ftools
//ssc install reghdfe
//ssc install ivreghdfe
//ssc install estout
//ssc install coefplot
//ssc install spmap
//ssc install shp2dta
//ssc install mif2dta

*** This file reproduces all tables and figures in the main text 
*** February, 2022 

clear all
macro drop _all
set matsize 10000


global user "" //set your cd
global path "$user/Replication Package Main" //
global data "$path/data/"
global dofiles "$path/codes/"
global output "$path/results/"

******************** Main results - figures *********************

// Great Migration and Northern Whites' Attitudes
do "$dofiles/Figure1.do"

// Change in Black Population Share, 1940 to 1970
do "$dofiles/Figure2.do"

// Discharge Petitions on Civil Rights Signed by Non-Southern Legislators
do "$dofiles/Figure3.do"

// Change in Signatures on Discharge Petitions
do "$dofiles/Figure4.do"

// Estimates on the Behavior of White Voters
do "$dofiles/Figure5.do"

// Newspapers – Event Study
do "$dofiles/Figure6.do"

// Heterogeneity by County Characteristics – Political and Economic Forces
do "$dofiles/Figure7.do"


********************* Main results - tables *********************

// Summary stats 
do "$dofiles/Table1.do"

// Congressional Elections - county
do "$dofiles/Table2.do"

// Congressional Elections - CZ
do "$dofiles/Table2_CZ.do"

// Changes in Legislators' Ideology
do "$dofiles/Table3.do"

// NAACP Chapters and COREDemonstrations
do "$dofiles/Table4.do"

// Whites' Attitude from the ANES 
do "$dofiles/Table5.do"

// Evidence from Northern Newspapers: Cross-sectional Regressions
do "$dofiles/Table6.do"

// Evidence from Northern Newspapers: Event-Study Design
do "$dofiles/Table7.do"
